<?php

class SchoolController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'index';
	public $menu = null;

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->menu;
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated user to perform actions
				'actions'=>array('index','update','create','delete'),
				'roles'=>array('admin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionIndex()
	{
		$model = new Szkola('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Szkola'])){
			$model->attributes=$_GET['Szkola'];
		}

		$dataProvider = new CActiveDataProvider('Szkola', array(
			'pagination'=>array(
				'pageSize'=>50,
			),));

		$this->render('index', array(
			'dataProvider'=>$dataProvider,
			'model'=>$model
		));
	}

	public function actionUpdate($id)
	{
		$model = Szkola::model()->findByPk($id);

		if(isset($_POST['Szkola']))
		{
			$model->attributes = $_POST['Szkola'];

			if($model->validate())
			{
				$model->save(false);

				Yii::app()->user->setFlash('schoolUpdated', 'Szkoła "'.$model->nazwa.'" została pomyślnie zaktualizowana.');
				$this->redirect(array('index'));
			}
		}

		$this->render('update', array(
			'model'=>$model,
		));
	}

	public function actionCreate()
	{
		$model = new Szkola;

		if(isset($_POST['Szkola']))
		{
			$model->attributes = $_POST['Szkola'];
			$model->idMapy = 1;
			if($model->validate())
			{
				$model->save(false);

				Yii::app()->user->setFlash('schoolCreated', 'Szkoła "'.$model->nazwa.'" została pomyślnie utworzona.');
				$this->redirect(array('index'));
			}
		}

		$this->render('create',array(
			'model'=>$model
		));
	}

	public function actionDelete($id)
	{
		try
		{
			$this->loadModel($id)->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

}
